<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Worker_Check extends Controller{

    public function before(){
        if(Auth::instance()->logged_in())
            return parent::before();
        else
            HTTP::redirect('/');
    }

    public function action_filter(){
        $user_id = Auth::instance()->get_user()->id;

        $progress = ORM::factory('Gearman_Progress')
            ->where('worker', '=', 'Filter')
            ->and_where('user_id', '=', $user_id)
            ->find();
        $result = $progress->as_array();

        $cache = ORM::factory('Cache_Filter')
            ->where('user_id', '=', $user_id)
            ->find_all();
        $result['count_all'] = $cache->count();
        $result = json_encode($result);

        if($progress->loaded()){
            $this->response->body($result);
        }
    }

    public function action_count(){
        
        $serverstatCountImport = ORM::factory('Serverstat', 'CountImport');
        if ( $serverstatCountImport->loaded() )
        {
            $result = $serverstatCountImport->value;
        }
        else
        {
            $count = null;
            $client = Task_Helper::getImportClient();
            $client->setCompleteCallback(function($task) use(&$count){
                $count = $task->data();
            });
            $client->addTask("Count", '_');
            $client->runTasks();
            
            $result = $count;
        }
        
        $this->response->body($result);
    }

    public function action_time()
    {
        $serverstatLastInsert = ORM::factory('Serverstat', 'LastInsert');
        $serverstatLastInsert->name = 'LastInsert';
        $result = $serverstatLastInsert->getValueFormatted();
        
        $this->response->body($result);
    }

    public function action_isset_client(){
        $client = trim($this->request->post('client_id'));
        if( preg_match('#.*\.(.*)#', $client, $tmp) ){
            if( isset($tmp[1]) ){
                $this->echo_result($tmp[1]);
            }
        }else{
            $this->echo_result($client);
        }
    }

    private function echo_result($client){
        $model = Model::factory('Client')->getClientInfo($client);
        if( is_array($model) && !empty($model) ){
            $this->response->body(json_encode([
                'find' => true,
                'url' => '/logpost/more_ex/'.$client
            ]));
        }else{
            $this->response->body(json_encode([
                'find' => false,
                'other' => $client
            ]));
        }
    }
}